%==============================================================================
% icst.cls - JAS 认可期刊文档类
% 创建者：Alistair Smith, Sunrise Setting Ltd
% 创建日期：2011年2月1日
% 最后更新：2011年4月11日 v1.11
%==============================================================================

% 版本信息宏，记录最后更新日期和版本号
\def\update{2025/11/11 v1.11}

% 期刊基本身份信息定义
\newcommand{\journalnamelc}{ WEDC}
\newcommand{\journalabb}{WEDC}
\newcommand{\journalclass}{wedc.cls}
\newcommand{\journalclassshort}{icst}

% LaTeX2e 文档类声明，基于标准 article 类
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{wedc}[\update\ \journalclass]

%==============================================================================
% 文档类选项处理
%==============================================================================
% 双倍行距选项，用于稿件审阅阶段
\newif\if@doublespace
\DeclareOption{doublespace}{%
\@doublespacetrue}

% 生产模式选项，启用正式出版所需的字体和Logo
\newif\if@production
\DeclareOption{production}{%
\@productiontrue}

% 独立字体选项，强制使用期刊特定字体配置
\newif\if@fonts
\DeclareOption{fonts}{%
\@fontstrue}

% 单栏模式选项，默认为双栏排版
\newif\if@onecolumn
\DeclareOption{onecolumn}{%
\@onecolumntrue}

% 将未识别的选项传递给基类 article
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions

%==============================================================================
% 基础类加载与页面模式设置
%==============================================================================
\LoadClass{article}
% 根据选项设置单栏或双栏模式
\if@onecolumn
\@twocolumnfalse
\else
\twocolumn
\fi

%==============================================================================
% 字体配置（生产模式或字体选项开启时）
%==============================================================================
% 生产模式下加载T1编码和kpfonts，并设置无衬线字体为iwonac
\if@production
\usepackage[T1]{fontenc}
\usepackage[nosf]{kpfonts}
\edef\sfdefault{iwonac}
\fi
% 独立字体选项（功能与production相同）
\if@fonts
\usepackage[T1]{fontenc}
\usepackage[nosf]{kpfonts}
\edef\sfdefault{iwonac}
\fi

%==============================================================================
% 行距设置（双倍行距选项开启时）
%==============================================================================
\if@doublespace
\RequirePackage[onehalfspacing]{setspace}
\fi

%==============================================================================
% 期刊名称显示设置
%==============================================================================
% 默认显示为"Preprint"，生产模式下显示完整期刊名
\gdef\set@journalname{Preprint}
\if@production
\gdef\set@journalname{ \@journalname}
\fi

%==============================================================================
% 宏包加载
%==============================================================================
\RequirePackage{graphicx}        % 图片支持
\RequirePackage{pifont,latexsym,ifthen,rotating,calc,textcase,booktabs,color,framed} % 符号、旋转、颜色等工具
\RequirePackage{amsfonts,amssymb,amsbsy,amsmath,amsthm} % AMS数学环境
\RequirePackage{titlesec,enumitem} % 标题和列表格式控制
% \RequirePackage{flushend}        % 平衡双栏最后一页
\RequirePackage[errorshow]{tracefnt} % 字体追踪调试用
\RequirePackage{caption}         % 图表标题格式

%==============================================================================
% 页面基础设置
%==============================================================================
\@twosidetrue                    % 启用双面模式
\flushbottom                     % 使页面内容垂直对齐
\frenchspacing                    % 法语间距（句后单空格）

%==============================================================================
% 页面尺寸设置（A4纸张）
%==============================================================================
\textwidth 178mm                 % 文本宽度
\textheight 236mm                % 文本高度
\setlength\columnsep{6mm}        % 双栏间距
\columnwidth 86mm                % 单栏宽度

% 页边距设置（去除默认1英寸偏移后重新设置）
\setlength\voffset{-1in}
\setlength\hoffset{-1in}
\topmargin 10mm                  % 上边距
\setlength\oddsidemargin{16mm}   % 奇数页左边距（装订边）
\setlength\evensidemargin{16mm}  % 偶数页左边距
\setlength\paperwidth{210mm}     % 纸张宽度（A4）
\setlength\paperheight{297mm}    % 纸张高度（A4）
\special{papersize=210mm,297mm}  % 设置PDF页面尺寸

%==============================================================================
% 段落和间距设置
%==============================================================================
\setlength\parskip{0\p@ \@plus \p@}  % 段落间距（基本为0，可弹性伸长）
\parindent 1em                   % 段落缩进
\headheight 50pt                 % 页眉高度
\headsep    17pt                 % 页眉与正文间距
\footskip 24pt                   % 页脚与正文间距

%==============================================================================
% 断字和排版惩罚值设置（严格质量控制）
%==============================================================================
\hyphenpenalty=1000               % 断字惩罚，值越高越少断字
\pretolerance=8000               % 第一次断行尝试的容忍度
\tolerance=9500                  % 最终容忍度
\hbadness=8000                   % 水平盒子警告阈值
\vbadness=9000                   % 垂直盒子警告阈值
\displaywidowpenalty=0           % 公式前后孤行惩罚
\clubpenalty=10000               % 孤行惩罚（段落首行单独在页尾）
\widowpenalty=10000              % 寡行惩罚（段落末行单独在页首）
\lefthyphenmin=3%               % 左侧最小断字长度
\righthyphenmin=3%               % 右侧最小断字长度
\brokenpenalty=10000%            % 断页惩罚
\hbadness=10000                  % 水平盒子错误阈值
\vbadness=10000                  % 垂直盒子错误阈值

%==============================================================================
% 数学间距微调
%==============================================================================
\thinmuskip = 3mu                % 薄空格（数学模式）
\medmuskip = 4mu                 % 中空格
\thickmuskip = 5mu               % 厚空格

%==============================================================================
% 浮动体参数设置（允许更多浮动）
%==============================================================================
\setcounter{topnumber}{10}        % 页顶浮动体最大数量
\def\topfraction{1}               % 页顶浮动体最大占比
\setcounter{bottomnumber}{10}     % 页底浮动体最大数量
\def\bottomfraction{0.8}          % 页底浮动体最大占比
\setcounter{totalnumber}{10}      % 单页浮动体总数
\def\textfraction{0}              % 文本最小占比
\renewcommand{\floatpagefraction}{0.95}  % 浮动页的最小浮动体占比
\setcounter{dbltopnumber}{10}     % 双栏浮动体数量
\renewcommand{\dblfloatpagefraction}{0.95} % 双栏浮动页占比
\renewcommand{\dbltopfraction}{1} % 双栏页顶浮动体最大占比

%==============================================================================
% 作者单位计数器
%==============================================================================
\newcounter{affilcount}
\setcounter{affilcount}{0}

%==============================================================================
% 字体大小重定义（标准LaTeX尺寸）
%==============================================================================
\renewcommand\normalsize{%       % 正常尺寸（10pt基线12pt）
   \@setfontsize\normalsize\@xpt\@xiipt
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize

\renewcommand\small{%            % 小尺寸（9pt基线11pt）
   \@setfontsize\small\@ixpt{11}%
   \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}

% 脚注尺寸（8pt基线9.5pt）
\renewcommand\footnotesize{%
   \@setfontsize\footnotesize\@viiipt{9.5}%
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}

% 其他尺寸定义
\renewcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
\renewcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\renewcommand\large{\@setfontsize\large\@xiipt{14}}
\renewcommand\Large{\@setfontsize\Large\@xivpt{18}}
\renewcommand\LARGE{\@setfontsize\LARGE\@xviipt{20}}
\renewcommand\huge{\@setfontsize\huge\@xxpt{23}}
\renewcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}

%==============================================================================
% 期刊品牌颜色定义
%==============================================================================
\definecolor{wedcgray}{gray}{0.5}      % 灰色（用于装饰元素）
\definecolor{wedcgreen}{cmyk}{0.78,0.30,0.88,0.40}

%==============================================================================
% 元数据命令定义（供用户在文档中设置）
%==============================================================================
% 文章类型（如：Research Article, Review等）
\def\articletype#1{%
\gdef\@articletype{{#1}}}
\let\@articletype\@empty

% 期刊名称
\def\journalname#1{%
\gdef\@journalname{{#1}}}
\let\@journalname\@empty

% 版权信息行
\def\copyrightline#1{%
\gdef\@copyrightline{{#1}}}
\let\@copyrightline\@empty

% 版权行自动生成（生产模式）
\gdef\@copyrightline{Copyright\ \copyright\ \volumeyear\ \copyrightholder}
\newcommand\copyrightnote[1]{%
  \g@addto@macro\@copyrightline{{. #1}}}
\let\@copyrightnote\@empty

% DOI信息行
\def\doiline#1{%
\gdef\@doiline{{#1}}}
\let\@doiline\@empty

% DOI自动生成（生产模式）
\if@production
\gdef\@doiline{{doi:}\articledoi}
\fi

%==============================================================================
% 摘要环境定义（带蓝色背景框）
%==============================================================================
% 计算minipage宽度（用于页脚信息居中）
\newlength\abswidth
\setlength{\abswidth}{\textwidth}
\addtolength{\abswidth}{-24pt}

% 蓝色背景盒子环境（用于摘要）
\newenvironment{tintbox}{%
  \def\FrameCommand{\setlength{\fboxsep}{12pt}\colorbox{wedcgreen}}%
  \MakeFramed {\advance\hsize-\width\FrameRestore}}%
 {\endMakeFramed}

% 摘要命令（自动添加蓝色背景和白色文字）
\long\def\abstract#1{\gdef\@abstract{%
\setlength\parskip{10\p@ \@plus \p@}\parindent 0pt\section*{\abstractname}\vspace*{-12pt}%
\begin{tintbox}\vspace*{-10pt}{\color{white}#1}\end{tintbox}}
}

% 摘要结束标记（用于控制间距）
\def\@endabstract{}
\def\endabstract{\gdef\@endabstract{}}
\let\@abstract\@empty

% 关键词命令
\def\keywords#1{%
  \gdef\@keywords{\textbf{keywords:}\hspace{0.75em}{#1}}}
\let\@keywords\@empty

%==============================================================================
% 脚注和通讯作者设置
%==============================================================================
% 脚注与正文间距
\skip\footins 22pt plus  8pt
% 脚注线定义
\def\footnoterule{\kern-3\p@
  \hrule \@width \columnwidth \kern 2.6\p@}

% 脚注文本格式
\long\def\@makefntext#1{\parindent 1em%
\noindent{$\m@th^{\@thefnmark}$}#1}

% 通讯作者地址（特殊脚注，无标记）
\def\corraddr#1{%
  \gdef\@corraddr{%
   {\footnotetext[0]{$^{\text{*}}$通讯作者: #1}}}}
\let\@corraddr\@empty
\def\corrauth{$^{\text{*}}$}

% 作者地址命令
\def\address#1{%
  \gdef\@address{{#1}}}
\let\@address\@empty

%==============================================================================
% 收稿/录用/出版日期命令
%==============================================================================
\def\received#1{%
  \gdef\@received{收稿于 #1}}
\let\@received\@empty

% 录用日期（可选格式参数）
\newcommand\accepted[2][录用日期]{%
  \g@addto@macro\@accepted{{; #1 #2}}}
\let\@accepted\@empty

% 出版日期（可选格式参数）
\newcommand\published[2][出版日期]{%
  \g@addto@macro\@published{{; #1 #2}}}
\let\@published\@empty

% 修正日期（可选格式参数）
\newcommand\corrected[2][修正日期]{%
  \g@addto@macro\@corrected{{; #1 #2}}}
\let\@corrected\@empty

%==============================================================================
% 标题页特殊脚注系统（作者单位、通信标记等）
%==============================================================================
% 重置计数器和分隔符
\let\comma\@empty
\let\tnotesep\@empty

% 标签系统（用于引用脚注标记）
\def\icstLabel#1{\@bsphack\protected@write\@auxout{}%
         {\string\Newlabel{#1}{\@currentlabel}}\@esphack}
\def\Newlabel#1#2{\expandafter\xdef\csname X@#1\endcsname{#2}}

% 引用标签
\def\icstRef#1{\@ifundefined{X@#1}{0}{\csname X@#1\endcsname}%
}

%==============================================================================
% 标题页脚注：正文注释（tnote）
% 使用星号符号(★)标记，用于文章标题注释
%==============================================================================
% 正文注释标记（如标题脚注）
% 支持多个标记，如 \tnotemark[1,2]
\def\tnotemark[#1]{\textsuperscript{\@for\@@tmark:=#1\do{%
      \edef\tnotenum{\@ifundefined{X@\@@tmark}{1}{\icstRef{\@@tmark}}}%
      \ifcase\tnotenum\or\ding{72}\or,\ding{72}\ding{72}\fi}}%
}
\let\@tnotemark\@empty

% 正文注释文本
\let\@tnotes\@empty
\newcounter{tnote}
\def\tnotetext[#1]#2{\g@addto@macro\@tnotes{%
  \refstepcounter{tnote}\icstLabel{#1}%
   \def\thefootnote{\ifcase\c@tnote\or\text{\ding{72}}\or\text{\ding{72}\ding{72}}\fi}%
    \footnotetext{#2}}}

%==============================================================================
% 标题页脚注：作者单位（fnote）
% 使用传统符号(*,†,‡等)标记，用于作者单位
%==============================================================================
% 作者单位标记（支持多标记和自动编号）
\def\fnotemark[#1]{\textsuperscript{\@for\@@tmark:=#1\do{%
      \edef\fnotenum{\@ifundefined{X@\@@tmark}{1}{\icstRef{\@@tmark}}}%
      \ifcase\fnotenum\or%
      \ifthenelse{\value{affilcount}=0}{$*$}{,$*$}% 第一个标记不加逗号
      \or ,$\dagger$\or ,$\ddagger$\or
   ,$\mathsection$\or ,$\mathparagraph$\or ,$\|$\or ,$**$\or ,$\dagger\dagger$
   \or ,$\ddagger\ddagger$\fi}}%
}
\let\@fnotemark\@empty

% 作者单位文本
\let\@fnotes\@empty
\newcounter{fnote}
\def\fnotetext[#1]#2{\g@addto@macro\@fnotes{%
  \refstepcounter{fnote}\icstLabel{#1}%
   \def\thefootnote{\ifcase\c@fnote\or *\or \dagger\or \ddagger\or
   \mathsection\or \mathparagraph\or \|\or **\or \dagger\dagger
   \or \ddagger\ddagger\fi}%
    \footnotetext{#2}}}

% 引用命令
\def\tnoteref#1{\tnotemark[#1]}
\def\fnoteref#1{\fnotemark[#1]}

% 重置脚注计数器（用于标题页）
\def\resetTitleCounters{\c@fnote=0 \c@tnote=0}

% 打印标题页所有脚注
\def\printFirstPageNotes{%
  \ifx\@tnotes\@empty\else\@tnotes\fi
   \ifx\@fnotes\@empty\else\@fnotes\fi
}

% 邮箱链接命令
\newcommand{\email}[1]{\href{mailto:<#1>}{#1}}

%==============================================================================
% 作者单位辅助命令
%==============================================================================
% 单位编号命令（用于作者名后）
\def\affilnum#1{${}^{#1}$\ignorespaces}
% 单位标记命令（设置计数器避免重复）
\def\affil#1{${}^{#1}$\setcounter{affilcount}{1}}

%==============================================================================
% 标题生成命令（重定义\maketitle）
%==============================================================================
\renewcommand\maketitle{\par
  \begingroup%
     \if@twocolumn%
      \ifnum \col@number=\@ne%
        \@maketitle%              % 单栏模式直接生成
      \else
        \twocolumn[\@maketitle]%  % 双栏模式跨栏生成标题
       \fi
    \else
      \newpage%
      \global\@topnum\z@%         % 防止浮动体出现在页顶
      \@maketitle%
    \fi
    \thispagestyle{title}\label{FirstPage}\printFirstPageNotes% 应用标题页样式并打印脚注
      \endgroup
  % 清理命令，防止后续重复使用
  \global\let\address\relax
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\@address\@empty
  \global\let\corraddr\relax
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}

% 实际标题生成内部命令
\def\@maketitle{\if@twocolumn\vspace*{-12pt}\else\vspace*{-32pt}\fi%
\null%
  % 标题：蓝色、加粗、Huge尺寸
  {\raggedright\huge\color{wedcgreen}\bfseries\@title \par}%
    \vskip 12pt %
    % 作者信息：large尺寸
    {\large%
      \noindent\@author\par}%
      \vskip 11pt%
    % 作者地址
{\normalsize
      {\raggedright\@address}
      \par}
      % 摘要（如果有）
%      \ifx\@abstract\@empty\addvspace{12pt}\else\addvspace{7pt}%
%          {\@abstract \@endabstract}\fi%

% 摘要区域垂直间距控制
\begingroup
  \ifx\@abstract\@empty
    % 无摘要：增大段间距
    \vspace{12pt}%
  \else
    % 有摘要：紧凑间距 + 输出内容
    \vspace{7pt}%
    \@abstract      % 输出摘要主体
    \@endabstract   % 输出摘要结束符（通常为空）
  \fi
\endgroup
          
     % 收稿日期、关键词、版权、DOI等信息（居中minipage），doi暂时取消！
     \centering\begin{minipage}{\abswidth}
    \ifx\@received\@empty\else\vspace*{6pt}%
    {\small\@received\@accepted\@published\@corrected\par}\fi
    \ifx\@keywords\@empty\else\addvspace{3pt}%
   {\small\noindent\@keywords\par}\fi
    \ifx\@copyrightline\@empty\else\addvspace{3pt}%
    {\small\@copyrightline\par}\fi
   % \ifx\@doiline\@empty
  %  \else\addvspace{3pt}%
  %  {\small\@doiline\par}\fi
    \end{minipage}
     \vspace*{24pt}%
        \par%
        }

%==============================================================================
% 页码和元数据命令
%==============================================================================
% 获取首页和末页页码
\def\startpage{\pageref{FirstPage}}
\def\endpage{\pageref{LastPage}}

% 期刊卷期信息占位符（用户需重新定义）
\def\volumeyear{XXXX}
\def\volumenumber{XX}
\def\issuemonth{XX}
\def\issuenumber{00}
\def\articleid{00-00-00-00}
\def\copyrightholder{WEDC}

% 运行标题（页眉显示）
\def\runningheads#1#2{\markboth{{#1}}{{#2}}}

%==============================================================================
% 标题页页脚定义（包含Logo、页码和期刊信息）
%==============================================================================
% 右侧页脚内容（生产模式显示完整信息）
\gdef\set@rhtitlepagefooter{WEDC Preprint}

\if@production
\gdef\set@rhtitlepagefooter{\parbox{0.55\textwidth}{

\raggedleft\small
  \ %
  }
  }
\fi

% 完整页脚定义（三栏布局：Logo | 页码 | 期刊信息）
\def\titlepagefooter{%
  \begingroup
    \footnotesize\sffamily
    \setlength{\tabcolsep}{3pt}%
    %
    \makebox[\textwidth][s]{%
     
      % 左栏下：Logo
      \parbox[b]{80mm}{%
        \begin{tabular}[t]{@{}l@{}}
          \if@production
         \else
            \hspace{25mm}% 非生产模式预留空间
          \fi
        \end{tabular}%
      }%
    
      %
      % 中栏：页码
      \begin{tabular}[t]{@{}c@{}}
        \\ % 空行产生垂直间距
        \thepage
      \end{tabular}%
      %
      % 右栏：期刊信息
      \parbox[b]{80mm}{%
        \begin{tabular}[t]{@{}r@{}}
          \set@rhtitlepagefooter
        \end{tabular}%
      }%
    }%
  \endgroup
}
%==============================================================================
% 页面样式定义
%==============================================================================
% 标题页样式（第一页）
\def\ps@title{%
\def\@oddhead{% 页眉（单双页相同）
\parbox[b]{\textwidth}{%
\if@production
%\includegraphics[width=10mm]{media/logo1}\hspace{-10mm}%%左上
\fi{\sf\bfseries\huge   \set@journalname
\,
\hfill%
\normalfont\large{\color{wedcgray}\@articletype}\ \ \raisebox{-0.5pt}

{{\if@production\includegraphics[width=15mm]{media/logo2}\fi}}
}\\[-6pt]
\noindent\rule{\textwidth}{1.0pt}}}% 底部横线
\let\@evenhead\@oddhead
\def\@oddfoot{% 页脚
\titlepagefooter%
}
\let\@evenfoot\@oddfoot}

% 后续页面样式
\def\ps@icstpage{
\let\@mkboth\@gobbletwo
\def\@evenhead{\parbox[b]{\textwidth}{% 偶数页页眉（左标记）
\mbox{}\small\sf{\leftmark}\hfill\mbox{}\\[-2pt]
\noindent\rule{\textwidth}{0.5pt}}}
\def\@oddhead{\parbox[b]{\textwidth}{% 奇数页页眉（右标记）
\mbox{}\hfill\small\sf{\rightmark}\mbox{}\\[-2pt]
\noindent\rule{\textwidth}{0.5pt}}}
\def\@evenfoot{% 页脚与标题页相同
\titlepagefooter}
\def\@oddfoot{\@evenfoot}
}

%==============================================================================
% 附录环境重定义
%==============================================================================
\renewcommand\appendix{\par
\setcounter{subsection}{0}%      % 重置subsection计数器
\setcounter{figure}{0}%          % 重置图表计数器
\setcounter{table}{0}%
\setcounter{equation}{0}%
\def\thefigure{\thesection.\arabic{figure}}%  图表编号带附录字母
\def\thetable{\thesection.\arabic{table}}%
\def\theequation{\thesection.\arabic{equation}}%
\gdef\thesection{\@Alph\c@section}}% 附录章节用字母编号

\setcounter{secnumdepth}{2}      % 章节编号深度（到subsection）
\titlelabel{\thetitle.}          % 标题标签格式

%==============================================================================
% 标题格式定义（使用titlesec宏包）
%==============================================================================
% 一级标题：section
\titleformat{\section}[block]
{\normalfont\large\sf\bfseries\color{wedcgreen}}
{\thesection.}
{0.5em}
{\normalfont\large\sf\bfseries\raggedright}

% 带附录标记的section格式（用于appendices环境）
\newcommand{\appmark}{}
\newenvironment{appendices}
{\setcounter{section}{0}\appendix\renewcommand{\appmark}{附录~}}
{}
\titleformat{\section}[block]
{\normalfont\large\sf\bfseries\color{wedcgreen}}
{\appmark\thesection.}
{0.5em}
{\normalfont\large\sf\bfseries\raggedright}

\titlespacing*{\section}{0pt}{12pt \@plus 2pt \@minus 2pt}{6pt\@plus 2pt \@minus 2pt} % 间距

% 二级标题：subsection
\titleformat{\subsection}[block]
{\normalfont\large\sf\color{wedcgreen}}
{\thesubsection.}
{0.5em}
{\normalfont\large\sf\raggedright}

\titlespacing*{\subsection}{0pt}{12pt \@plus 2pt \@minus 2pt}{6pt\@plus 2pt \@minus 2pt}

% 三级标题：subsubsection（runin格式，标题与正文同行）
\newcommand{\periodafter}[1]{#1.}
\titleformat{\subsubsection}[runin]
{\normalfont\normalsize\sf\bfseries\color{wedcgreen}}
{\thesubsubsection.}
{0.5em}
{\normalfont\normalsize\sf\bfseries\periodafter}

\titlespacing*{\subsubsection}{0pt}{6pt \@plus 2pt \@minus 2pt}{1em} % 1em为标题后间距

%==============================================================================
% 列表环境设置（enumitem宏包）
%==============================================================================
\setlist{partopsep=0pt,topsep=6pt \@plus 1pt \@minus 1pt} % 列表间距

%==============================================================================
% 图表标题格式（caption宏包）
%==============================================================================
% 图注前缀
\renewcommand{\figurename}{Figure}

% 标题分隔符定义（句点+半空格）
\DeclareCaptionLabelSeparator{icstperiod}{.\hspace*{0.5em}}

% 图片标题设置
\captionsetup[figure]{font={normalsize,sf},labelfont=bf,labelsep=icstperiod,justification=justified,singlelinecheck=true}

% 表格标题设置（标题在上方）
\captionsetup[table]{position=top,font={normalsize,sf},labelfont=bf,labelsep=icstperiod,justification=justified,singlelinecheck=true}

%==============================================================================
% 定理样式定义（amsthm宏包）
%==============================================================================
\newtheoremstyle{wedc}
{6pt plus 2pt minus 2pt}%      % 定理环境上方间距
{6pt plus 2pt minus 2pt}%      % 定理环境下方间距
{\normalfont}%                  % 定理内容字体
{}%                             % 缩进
{\normalfont\normalsize\sf\bfseries\color{wedcgreen}}% 定理头字体
{.}%                            % 定理头后标点
{ }%                            % 定理头后间距
{}%                             % 定理头格式

\theoremstyle{wedc}

%==============================================================================
% 致谢命令
%==============================================================================
\newcommand\ack{\vspace{6pt}\subsubsection*{Acknowledgements}\small}
\newcommand\acks{\vspace{6pt}\subsubsection*{Acknowledgements}\small}

%==============================================================================
% 参考文献格式（natbib宏包）
%==============================================================================
\renewcommand\refname{References} % 参考文献标题
\usepackage[numbers,sort&compress]{natbib} % 数字引用，排序并压缩（如[1-3]）
\setlength{\bibsep}{0pt}         % 文献条目间距
\renewcommand{\bibfont}{\small}  % 文献字体大小
\let\cite\citep                   % 将\cite重定向为\citep

%==============================================================================
% 文档结束处理
%==============================================================================
% 在文档末尾添加LastPage标签（用于计算总页数）
\AtEndDocument{%
\label{LastPage}}

%==============================================================================
% 其他设置
%==============================================================================
% 断字规则
\hyphenation{com-mu-ni-ca-tions}

% 默认页面样式
\pagestyle{icstpage}
\sloppy                          % 宽松排版（减少溢出警告）